fragile_nuc = read.csv('~/feature_file/nucs_not_in_400U_MNase.csv')

#define the read boudaries (nucleosomal or subnucleosomal)
length_min = 140
length_max = 180

band=30

file_name = c("wt_pulse","wt_c10","wt_c15","wt_c20","wt_c40",
              "cac_pulse","cac_c10","cac_c15","cac_c20","cac_c40")
file_extension= c("_sampled","_sampled","_sampled","_sampled","_sampled",
                  "_sampled","_sampled","_sampled","_sampled","_sampled")
#setting up parameters
options(scipen=999) #disabling scientific notation 1= "230218",
chr_coordinates.df = data.frame(chr=(c("chrI", "chrII", "chrIII", "chrIV", "chrV", "chrVI", "chrVII", "chrVIII", "chrIX", "chrX", "chrXI", "chrXII",
                                       "chrXIII", "chrXIV", "chrXV","chrXVI")),
                                end=as.numeric(c("230218","813184", "316620", "1531933", "576874", "270161", "1090940", "562643", "439888", "745751", "666816", "1078177", "924431", "784333", "1091291", "948066")), stringsAsFactors=FALSE)
cn <- c("wt_p","wt_c10","wt_c15","wt_c20","wt_c40",
        "cac_p","cac_c10","cac_c15","cac_c20","cac_c40")
fragile_nuc[cn] <- 0

index_file = chr_coordinates.df

# this is  to create a list of matrices to be able to call them individually later on.
data = vector("list")

for(r in 1:nrow(index_file)){
  chr = index_file[r,"chr"] 
  
  new_start= 1
  new_end= index_file[r, "end"] 
  
  chr.gr = GRanges(seqnames= chr, ranges = IRanges(start =new_start , end = new_end ))
  
  p = ScanBamParam(what = c("rname", "strand", "pos", "isize"),which = chr.gr)
  
  
  for (f in 1:10){
    #data files
    file_name.bam = (paste("/data/home/bc202/cac/final/bam_bai/sampled/",file_name[f],file_extension[f],".bam", sep=''))
    file_name.bam.bai = paste("/data/home/bc202/cac/final/bam_bai/sampled/",file_name[f],file_extension[f],".bam.bai",sep='')  
    
    A_reads.l = scanBam(file = file_name.bam,
                        index = file_name.bam.bai,
                        param = p)
    
    #create a new GenomicRanges object for the reads from this list:
    A_reads.gr = GRanges(seqnames = A_reads.l[[1]]$rname,
                         ranges = IRanges(start = A_reads.l[[1]]$pos,
                                          width = A_reads.l[[1]]$isize))
    
    subset_data.gr = A_reads.gr[which(width(A_reads.gr) > length_min & width(A_reads.gr)< length_max)]
    
    #finding the mipoints of those reads. 
    midpoints.gr =IRanges(start=mid(ranges(subset_data.gr)), width=1) 
    
    data[[f]] = as.data.frame(subset_data.gr)
    midpoints = as.data.frame(midpoints.gr)
    data[[f]]$mid=midpoints$start
  }
    
  chr_k = which(fragile_nuc$chr == chr)
  for(i in chr_k){
    cat(paste("saving nucleosome", i,"on chromosome", r,"\n"))
    
    cstart = fragile_nuc$dyad[i] - 70
    cend = fragile_nuc$dyad[i] + 70
    
    for(f in 1:10){
      fragile_nuc[i,3+f]=length(which(data[[f]]$mid > cstart & data[[f]]$mid < cend))
    }
  }
  
}  


fragile_nuc$wt_ATI = NA
fragile_nuc$cac_ATI = NA

calc_ATI <- function(dat){
  dat2 <- dat/sum(dat)
  tmp <- 1/(((1*dat2[1]+2*dat2[2]+3*dat2[3]+4*dat2[4]+5*dat2[5]))/(5))
  return(tmp)
}

for (i in 1:nrow(fragile_nuc)) {
  wt_v = as.vector(as.matrix(fragile_nuc[i,4:8]))
  cac_v = as.vector(as.matrix(fragile_nuc[i,9:13]))
  fragile_nuc$wt_ATI[i] = calc_ATI(wt_v)
  fragile_nuc$cac_ATI[i]= calc_ATI(cac_v)
  
  if( i %% 500 ==0){
    cat(paste('nuc # ',i,'\n'))
  }
}

png(file = '~/data/supple5_fragile_nuc.png', width =5, height = 4, units = "in", res = 200, bg = "white", type = "cairo-png" )
par(mar = c(4,4,4,2), cex=0.8)
cl <- viridis(100, alpha = 1, begin = 0, end = 1, option = "D")
plot(density(nuc_master_sub$wt_ATI,bw=0.008),xlab='ATI',main='',col=cl[55],lwd=3.5,xlim=c(1.1,1.9))
lines(density(nuc_master_sub$cac_ATI,na.rm = TRUE,bw=0.008),col='orange',lwd=3.5)
lines(density(fragile_nuc$wt_ATI,na.rm = TRUE),col=cl[55],lwd=3.5,lty=2)
lines(density(fragile_nuc$cac_ATI,na.rm = TRUE),col='orange',lwd=3.5,lty=2)
legend('topleft',c('WT, all nucleosomes',expression(paste(italic(cac1),Delta,', all nucleosomes')),'WT, fragile nucleosomes',expression(paste(italic(cac1),Delta,', fragile nucleosomes'))),
       col=c(cl[55],'orange',cl[55],'orange'),lty=c(1,1,2,2),lwd=c(2.5,2.5,2.5,2.5),box.lwd = 0,box.col = "transparent",bg = "transparent")
dev.off()





